<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare('INSERT INTO responsable (id_eleve, nom_responsable, prenom_responsable, tel_responsable, email_responsable, num_rue_responsable, cp_responsable, ville_responsable) VALUES (:id, :nom, :prenom, :tel, :email, :num_rue, :cp, :ville)');
        $requete->bindParam(':id', $_POST['id']);
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':prenom', $_POST['prenom']);
        $requete->bindParam(':tel', $_POST['fixe']);
        $requete->bindParam(':email', $_POST['mail']);
        $requete->bindParam(':num_rue', $_POST['adresse']);
        $requete->bindParam(':cp', $_POST['cp']);
        $requete->bindParam(':ville', $_POST['ville']);
        $requete->execute();
        $bdd->commit();

        header('Location: responsables.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }

}
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Ajouter un responsable d'élève </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom">
                                    <label>Prénom</label>
                                    <input class="form-control" name="prenom">
                                    <label>Élève</label>
                                    <select class="form-control" name="id">
                                        <option value="">Aucun</option>
                                        <?php
                                        $requete = $bdd->prepare("SELECT nom, prenom, id_eleve FROM eleve");
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id_eleve']).'">'.htmlspecialchars($row['prenom'].' '.$row['nom']).'</option>';
                                        ?>
                                    </select>
                                    <label>Email</label>
                                    <input class="form-control" name="mail">
                                    <label>Adresse</label>
                                    <input class="form-control" name="adresse">
                                    <label>Code postal</label>
                                    <input class="form-control" name="cp">
                                    <label>Ville</label>
                                    <input class="form-control" name="ville">
                                    <label>Téléphone</label>
                                    <input class="form-control" name="fixe">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
